-- MFStrive Profile Schema Extension
-- Run after schema.sql: mysql -u root mfstrive < database/schema_profile.sql
-- Adds profile fields and related tables for dynamic profile loading

USE mfstrive;

-- Add profile columns to users table (run setup_profile_tables.php for safe migration)
-- ALTER TABLE users ADD COLUMN headline VARCHAR(500) DEFAULT NULL;
-- ALTER TABLE users ADD COLUMN location VARCHAR(255) DEFAULT NULL;
-- etc.

-- User experiences (work history)
CREATE TABLE IF NOT EXISTS user_experiences (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    company_name VARCHAR(255) NOT NULL,
    job_title VARCHAR(255) NOT NULL,
    employment_type VARCHAR(100) DEFAULT 'Full-time',
    start_date VARCHAR(100) DEFAULT NULL,
    end_date VARCHAR(100) DEFAULT NULL,
    duration VARCHAR(100) DEFAULT NULL,
    location VARCHAR(255) DEFAULT NULL,
    skills TEXT DEFAULT NULL,
    description TEXT DEFAULT NULL,
    display_order INT DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
    INDEX idx_user_id (user_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- User education
CREATE TABLE IF NOT EXISTS user_education (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    institution_name VARCHAR(255) NOT NULL,
    degree VARCHAR(255) NOT NULL,
    start_date VARCHAR(100) DEFAULT NULL,
    end_date VARCHAR(255) DEFAULT NULL,
    grade VARCHAR(100) DEFAULT NULL,
    location VARCHAR(255) DEFAULT NULL,
    skills TEXT DEFAULT NULL,
    display_order INT DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
    INDEX idx_user_id (user_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- User skills
CREATE TABLE IF NOT EXISTS user_skills (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    skill_name VARCHAR(255) NOT NULL,
    institution VARCHAR(255) DEFAULT NULL,
    is_top_skill TINYINT(1) DEFAULT 0,
    display_order INT DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
    INDEX idx_user_id (user_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- User certifications
CREATE TABLE IF NOT EXISTS user_certifications (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    title VARCHAR(500) NOT NULL,
    issuer VARCHAR(255) DEFAULT NULL,
    issued_date VARCHAR(100) DEFAULT NULL,
    credential_id VARCHAR(255) DEFAULT NULL,
    skills TEXT DEFAULT NULL,
    display_order INT DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
    INDEX idx_user_id (user_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
