<?php
/**
 * Load profile data for the current logged-in user from database
 * Returns array with user + experiences, education, skills, certifications
 */
function loadProfileData($conn)
{
    session_start();
    $userId = $_SESSION['user_id'] ?? 0;
    
    $profile = [
        'user' => null,
        'experiences' => [],
        'education' => [],
        'skills' => [],
        'top_skills' => [],
        'certifications' => []
    ];
    
    if ($userId <= 0) {
        return $profile;
    }

    $baseColumns = "id, username, first_name, last_name, email, phone, signature_path, resume_path";
    $profileColumns = "headline, location, about, about_extended, open_to_work_roles, score_rating, score_points, connection_degree";
    $columns = $baseColumns;

    try {
        $test = $conn->query("SELECT 1 FROM users LIMIT 1");
        $cols = $conn->query("SHOW COLUMNS FROM users LIKE 'headline'");
        if ($cols && $cols->num_rows > 0) {
            $columns = $baseColumns . ", " . $profileColumns;
        }
    } catch (Exception $e) {}

    $stmt = $conn->prepare("SELECT $columns FROM users WHERE id = ?");
    $stmt->bind_param('i', $userId);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($row = $result->fetch_assoc()) {
        $profile['user'] = array_merge([
            'headline' => null, 'location' => null, 'about' => null, 'about_extended' => null,
            'open_to_work_roles' => null, 'score_rating' => null, 'score_points' => null, 'connection_degree' => null
        ], $row);
    } else {
        return $profile;
    }

    try {
        $stmt = $conn->prepare("SELECT company_name, job_title, employment_type, start_date, end_date, duration, location, skills, description FROM user_experiences WHERE user_id = ? ORDER BY display_order ASC");
        $stmt->bind_param('i', $userId);
        $stmt->execute();
        $profile['experiences'] = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
    } catch (Exception $e) {}

    try {
        $stmt = $conn->prepare("SELECT institution_name, degree, start_date, end_date, grade, location, skills FROM user_education WHERE user_id = ? ORDER BY display_order ASC");
        $stmt->bind_param('i', $userId);
        $stmt->execute();
        $profile['education'] = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
    } catch (Exception $e) {}

    try {
        $stmt = $conn->prepare("SELECT skill_name, institution, is_top_skill FROM user_skills WHERE user_id = ? ORDER BY is_top_skill DESC, display_order ASC");
        $stmt->bind_param('i', $userId);
        $stmt->execute();
        $allSkills = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
        foreach ($allSkills as $s) {
            $profile['skills'][] = $s;
            if (!empty($s['is_top_skill'])) {
                $profile['top_skills'][] = $s['skill_name'];
            }
        }
        if (empty($profile['top_skills']) && !empty($profile['skills'])) {
            $profile['top_skills'] = array_slice(array_column($profile['skills'], 'skill_name'), 0, 4);
        }
    } catch (Exception $e) {}

    try {
        $stmt = $conn->prepare("SELECT title, issuer, issued_date, credential_id, skills FROM user_certifications WHERE user_id = ? ORDER BY display_order ASC");
        $stmt->bind_param('i', $userId);
        $stmt->execute();
        $profile['certifications'] = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
    } catch (Exception $e) {}
    
    return $profile;
}

/**
 * Get user initials from name
 */
function getInitials($firstName, $lastName)
{
    $f = mb_substr(trim($firstName), 0, 1);
    $l = mb_substr(trim($lastName), 0, 1);
    return strtoupper($f . $l) ?: '?';
}

/**
 * Escape for HTML output
 */
function h($s)
{
    return htmlspecialchars($s ?? '', ENT_QUOTES, 'UTF-8');
}
