<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login | Sign Up - MFStrive</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&family=Space+Grotesk:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="icon" type="image/png" href="logo-h.png">
    <link rel="stylesheet" href="auth.css">
</head>
<body data-debug="1">
    <div class="auth-wrapper">
        <div class="auth-container">
            <a href="profile.php" class="auth-logo">
                <img src="logo-h.png" alt="MFStrive" class="auth-logo-img">
            </a>
            
            <!-- Tabs -->
            <div class="auth-tabs">
                <button type="button" class="auth-tab active" data-tab="login">Login</button>
                <button type="button" class="auth-tab" data-tab="signup">Sign Up</button>
            </div>

            <!-- Login Form -->
            <form id="loginForm" class="auth-form active" method="post" action="api/auth.php">
                <input type="hidden" name="action" value="login">
                <div class="form-group">
                    <label for="login_username">Username *</label>
                    <input type="text" id="login_username" name="username" placeholder="Enter username" required>
                </div>
                <div class="form-group">
                    <label for="login_password">Password *</label>
                    <input type="password" id="login_password" name="password" placeholder="Enter password" required>
                </div>
                <button type="submit" class="btn-submit">Login</button>
                <div id="loginMessage" class="form-message"></div>
            </form>

            <!-- Signup Form -->
            <form id="signupForm" class="auth-form" method="post" action="api/auth.php" enctype="multipart/form-data">
                <input type="hidden" name="action" value="signup">
                <input type="hidden" id="signatureData" name="signature_data" value="">
                <div class="form-group">
                    <label for="signup_username">Username *</label>
                    <input type="text" id="signup_username" name="username" placeholder="Enter username" required>
                </div>
                <div class="form-row">
                    <div class="form-group">
                        <label for="first_name">First Name *</label>
                        <input type="text" id="first_name" name="first_name" placeholder="Enter first name" required>
                    </div>
                    <div class="form-group">
                        <label for="last_name">Last Name *</label>
                        <input type="text" id="last_name" name="last_name" placeholder="Enter last name" required>
                    </div>
                </div>
                <div class="form-group">
                    <label for="signup_email">Email *</label>
                    <input type="email" id="signup_email" name="email" placeholder="Enter email address" required>
                </div>
                <div class="form-group">
                    <label for="signup_password">Password *</label>
                    <input type="password" id="signup_password" name="password" placeholder="Enter password" required>
                </div>
                <div class="form-group">
                    <label for="phone">Phone Number *</label>
                    <input type="tel" id="phone" name="phone" placeholder="Enter phone number" required>
                </div>
                <div class="form-group">
                    <label for="resume">Upload Resume *</label>
                    <input type="file" id="resume" name="resume" accept=".pdf,.doc,.docx" required>
                    <span class="form-hint">Upload PDF or Word file (.pdf, .doc, .docx)</span>
                </div>
                <div class="form-group">
                    <label>Signature *</label>
                    <div class="signature-wrapper">
                        <canvas id="signatureCanvas" width="400" height="150"></canvas>
                        <div class="signature-actions">
                            <button type="button" id="clearSignature" class="btn-clear-signature">Clear Signature</button>
                            <span class="signature-hint">Draw your signature above</span>
                        </div>
                    </div>
                </div>
                <button type="submit" class="btn-submit">Sign Up</button>
                <div id="signupMessage" class="form-message"></div>
            </form>
        </div>
    </div>
    <script src="auth.js"></script>
</body>
</html>
