<?php
require_once __DIR__ . '/config/database.php';
require_once __DIR__ . '/includes/profile_data.php';

$profile = loadProfileData($conn);

if (!$profile['user']) {
    header('Location: index.php');
    exit;
}

$user = $profile['user'];
$fullName = trim(($user['first_name'] ?? '') . ' ' . ($user['last_name'] ?? ''));
$initials = getInitials($user['first_name'] ?? '', $user['last_name'] ?? '');
$headline = $user['headline'] ?? 'Software Engineer | Web Developer';
$location = $user['location'] ?? '';
$about = $user['about'] ?? '';
$aboutExtended = $user['about_extended'] ?? '';
$openToWork = $user['open_to_work_roles'] ?? 'Software Engineer, Web Developer';
$scoreRating = $user['score_rating'] ?? '8/10';
$scorePoints = $user['score_points'] ?? '10245 points';
$connectionDegree = $user['connection_degree'] ?? '2nd';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Candidate Profile - <?= h($fullName) ?> - MFStrive</title>
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&family=Space+Grotesk:wght@400;500;600;700&display=swap" rel="stylesheet">
    
    <link rel="icon" type="image/png" href="logo-h.png">
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <div class="container">
    <header class="menu-bar">
        <a href="#" class="menu-logo">
            <img src="logo-h.png" alt="MFStrive" class="logo-img">
        </a>
        <nav class="top-nav">
            <div class="nav-container">
            <a href="#" class="nav-item">
                <span class="nav-icon-wrapper">
                    <svg class="nav-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"/>
                        <polyline points="9 22 9 12 15 12 15 22"/>
                    </svg>
                    <span class="nav-notification-dot"></span>
                </span>
                <span class="nav-label">Home</span>
            </a>
            <a href="#" class="nav-item">
                <span class="nav-icon-wrapper">
                    <svg class="nav-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M18 8A6 6 0 0 0 6 8c0 7-3 9-3 9h18s-3-2-3-9"/>
                        <path d="M13.73 21a2 2 0 0 1-3.46 0"/>
                    </svg>
                </span>
                <span class="nav-label">Notifications</span>
            </a>
            <a href="#" class="nav-item">
                <span class="nav-icon-wrapper">
                    <svg class="nav-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <rect x="2" y="7" width="20" height="14" rx="2" ry="2"/>
                        <path d="M16 21V5a2 2 0 0 0-2-2h-4a2 2 0 0 0-2 2v16"/>
                    </svg>
                </span>
                <span class="nav-label">Applied Jobs</span>
            </a>
            <div class="nav-item nav-item-me" id="navMe">
                <span class="nav-icon-wrapper">
                    <div class="nav-profile-pic">
                        <div class="profile-initial"><?= h($initials) ?></div>
                    </div>
                    <svg class="nav-chevron" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <polyline points="6 9 12 15 18 9"/>
                    </svg>
                </span>
                <span class="nav-label">Me</span>
                <div class="me-dropdown" id="meDropdown">
                    <div class="me-dropdown-profile">
                        <div class="me-dropdown-avatar">
                            <div class="profile-initial"><?= h($initials) ?></div>
                        </div>
                        <div class="me-dropdown-info">
                            <h3 class="me-dropdown-name"><?= h($fullName) ?></h3>
                            <p class="me-dropdown-title"><?= h($headline) ?></p>
                            <div class="me-dropdown-buttons">
                                <button class="btn-view-profile">Edit profile</button>
                                <button class="btn-verify">Verify</button>
                            </div>
                        </div>
                    </div>
                    <div class="me-dropdown-section">
                        <h4 class="me-dropdown-heading">Account</h4>
                        <a href="#" class="me-dropdown-link">
                            <span class="me-dropdown-link-icon diamond">◆</span>
                            Premium features
                        </a>
                        <a href="#" class="me-dropdown-link">Settings & Privacy</a>
                        <a href="#" class="me-dropdown-link">Help</a>
                    </div>
                    <div class="me-dropdown-section">
                        <a href="logout.php" class="me-dropdown-link">Sign Out</a>
                    </div>
                </div>
            </div>
        </div>
    </nav>
    </header>

    <div class="profile-header">
        <div class="banner">
            <img src="https://images.unsplash.com/photo-1506905925346-21bda4d32df4?w=1200&h=300&fit=crop" alt="Banner" class="banner-image">
        </div>
        <div class="profile-info">
            <div class="profile-picture-container">
                <div class="profile-picture">
                    <div class="profile-logo"><?= h($initials) ?></div>
                </div>
                <div class="open-to-work-badge">#OPENTOWORK</div>
            </div>
            <div class="profile-details">
                <h1 class="profile-name"><?= h($fullName) ?> <span class="connection-badge">· <?= h($connectionDegree) ?></span></h1>
                <div class="profile-headline-row">
                    <p class="profile-headline"><?= h($headline) ?></p>
                    <div class="score-badge">
                        <span class="score-rating"><?= h($scoreRating) ?></span>
                        <span class="score-points"><?= h($scorePoints) ?></span>
                    </div>
                </div>
                <div class="location-info">
                    <span><?= h($location) ?: '—' ?></span>
                    <a href="#" class="contact-link">Contact info</a>
                </div>
                <div class="open-to-work-box">
                    <strong>Open to work</strong>
                    <p><?= h($openToWork) ?></p>
                    <a href="#" class="show-details">Show details</a>
                </div>
            </div>
        </div>
    </div>

    <div class="content-layout">
        <div class="main-content">
        <div class="section-card">
            <h2 class="section-title">About</h2>
            <div class="about-content">
                <p><?= nl2br(h($about ?: 'No about information yet.')) ?></p>
                <?php if ($aboutExtended): ?>
                <p class="about-text-collapsed"><?= nl2br(h($aboutExtended)) ?></p>
                <button class="see-more-btn" onclick="toggleAbout()">...see more</button>
                <?php endif; ?>
            </div>
            <div class="top-skills-card">
                <div class="top-skills-header">
                    <span class="diamond-icon">◆</span>
                    <h3 class="top-skills-title">Top skills</h3>
                    <span class="arrow-icon">→</span>
                </div>
                <div class="top-skills-list">
                    <?php
                    $topSkills = $profile['top_skills'];
                    if (empty($topSkills) && !empty($profile['skills'])) {
                        $topSkills = array_slice(array_column($profile['skills'], 'skill_name'), 0, 4);
                    }
                    if (empty($topSkills)) {
                        echo '<span>—</span>';
                    } else {
                        $parts = [];
                        foreach ($topSkills as $s) {
                            $parts[] = '<span>' . h($s) . '</span>';
                        }
                        echo implode('<span class="bullet">•</span>', $parts);
                    }
                    ?>
                </div>
            </div>
        </div>

        <div class="section-card">
            <h2 class="section-title">Experience</h2>
            <?php if (empty($profile['experiences'])): ?>
            <p class="profile-empty">No experience added yet.</p>
            <?php else: ?>
            <?php foreach ($profile['experiences'] as $exp): 
                $logoLetter = mb_substr($exp['company_name'], 0, 1);
            ?>
            <div class="experience-item">
                <div class="experience-header">
                    <div class="company-logo">
                        <div class="logo-placeholder"><?= h($logoLetter) ?></div>
                    </div>
                    <div class="experience-details">
                        <h3 class="job-title"><?= h($exp['job_title']) ?></h3>
                        <p class="company-name"><?= h($exp['company_name']) ?> · <?= h($exp['employment_type']) ?></p>
                        <p class="duration"><?= h($exp['start_date']) ?> - <?= h($exp['end_date']) ?><?= $exp['duration'] ? ' · ' . h($exp['duration']) : '' ?></p>
                        <?php if (!empty($exp['location'])): ?><p class="location"><?= h($exp['location']) ?></p><?php endif; ?>
                        <?php if (!empty($exp['skills'])): ?>
                        <div class="experience-skills">
                            <span class="diamond-icon">◆</span>
                            <span><?= h($exp['skills']) ?></span>
                        </div>
                        <?php endif; ?>
                        <?php if (!empty($exp['description'])): ?>
                        <p class="experience-desc"><?= nl2br(h($exp['description'])) ?></p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
            <?php endif; ?>
        </div>

        <div class="section-card">
            <h2 class="section-title">
                <span class="section-title-text">Assessment tests</span>
                <a href="#" class="re-appear-link">Re-Attempt</a>
            </h2>
            <div class="assessment-cards-grid">
                <div class="assessment-card">
                    <div class="assessment-card-icon react-icon">
                        <svg viewBox="-11.5 -10.23174 23 20.46348"><circle r="2.05" fill="currentColor"/><g stroke="currentColor" stroke-width="1" fill="none"><ellipse rx="11" ry="4.2"/><ellipse rx="11" ry="4.2" transform="rotate(60)"/><ellipse rx="11" ry="4.2" transform="rotate(120)"/></g></svg>
                    </div>
                    <h3 class="assessment-card-skill">React</h3>
                    <div class="assessment-card-score">
                        <span class="score-value">60</span>
                        <span class="score-out-of">/ 100</span>
                    </div>
                    <div class="assessment-card-progress">
                        <div class="progress-bar" style="--progress: 60%"></div>
                    </div>
                    <span class="assessment-card-badge">60%</span>
                </div>
                <div class="assessment-card">
                    <div class="assessment-card-icon html-icon">
                        <svg viewBox="0 0 24 24" fill="currentColor"><path d="M1.5 0h21l-1.91 21.563L11.977 24l-8.565-2.438L1.5 0zm7.031 9.75-.232-2.718 10.059.003.23-2.622L5.412 4.41l.698 8.01h9.126l-.326 3.426-2.91.804-2.955-.81-.188-2.11H6.248l.33 4.171L12 19.351l5.379-1.443.744-8.157H8.531z"/></svg>
                    </div>
                    <h3 class="assessment-card-skill">HTML</h3>
                    <div class="assessment-card-score">
                        <span class="score-value">70</span>
                        <span class="score-out-of">/ 100</span>
                    </div>
                    <div class="assessment-card-progress">
                        <div class="progress-bar" style="--progress: 70%"></div>
                    </div>
                    <span class="assessment-card-badge">70%</span>
                </div>
            </div>
        </div>

        <div class="section-card">
            <h2 class="section-title">Education</h2>
            <?php if (empty($profile['education'])): ?>
            <p class="profile-empty">No education added yet.</p>
            <?php else: ?>
            <?php foreach ($profile['education'] as $edu): ?>
            <div class="education-item">
                <div class="education-header">
                    <div class="university-logo">
                        <div class="logo-crest">🛡️</div>
                    </div>
                    <div class="education-details">
                        <h3 class="university-name"><?= h($edu['institution_name']) ?></h3>
                        <p class="degree"><?= h($edu['degree']) ?></p>
                        <p class="duration"><?= h($edu['end_date']) ?><?= !empty($edu['location']) ? ' · ' . h($edu['location']) : '' ?></p>
                        <?php if (!empty($edu['grade'])): ?><p class="grade"><?= h($edu['grade']) ?></p><?php endif; ?>
                        <?php if (!empty($edu['skills'])): ?>
                        <div class="education-skills">
                            <span class="diamond-icon">◆</span>
                            <span><?= h($edu['skills']) ?></span>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
            <?php endif; ?>
        </div>

        <div class="section-card">
            <h2 class="section-title">Skills</h2>
            <?php if (empty($profile['skills'])): ?>
            <p class="profile-empty">No skills added yet.</p>
            <?php else: ?>
            <div class="skills-list">
                <?php 
                $skillsToShow = array_slice($profile['skills'], 0, 3);
                $lastIdx = count($skillsToShow) - 1;
                foreach ($skillsToShow as $i => $sk): 
                ?>
                <div class="skill-item">
                    <div class="skill-content">
                        <h3 class="skill-name"><?= h($sk['skill_name']) ?></h3>
                        <?php if (!empty($sk['institution'])): ?>
                        <div class="skill-institution">
                            <div class="institution-logo">🛡️</div>
                            <span><?= h($sk['institution']) ?></span>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
                <?php if ($i < $lastIdx): ?><div class="skill-divider"></div><?php endif; ?>
                <?php endforeach; ?>
                <div class="skill-divider"></div>
                <div class="show-all-skills">
                    <a href="#" class="show-all-link">Show all <?= count($profile['skills']) ?> skills →</a>
                </div>
            </div>
            <?php endif; ?>
        </div>

        <div class="section-card">
            <h2 class="section-title">Licenses & certifications</h2>
            <?php if (empty($profile['certifications'])): ?>
            <p class="profile-empty">No certifications added yet.</p>
            <?php else: ?>
            <div class="certifications-list">
                <?php 
                $certsToShow = $profile['certifications'];
                $lastCertIdx = count($certsToShow) - 1;
                foreach ($certsToShow as $i => $cert): 
                ?>
                <div class="certification-item">
                    <div class="certification-header">
                        <div class="cert-logo">
                            <div class="cert-logo-placeholder">📊</div>
                        </div>
                        <div class="cert-details">
                            <h3 class="cert-title"><?= h($cert['title']) ?></h3>
                            <p class="cert-issuer"><?= h($cert['issuer']) ?></p>
                            <p class="cert-date">Issued <?= h($cert['issued_date']) ?></p>
                            <?php if (!empty($cert['credential_id'])): ?><p class="credential-id">Credential ID <?= h($cert['credential_id']) ?></p><?php endif; ?>
                            <?php if (!empty($cert['skills'])): ?>
                            <div class="cert-skill">
                                <span class="diamond-icon">◆</span>
                                <span><?= h($cert['skills']) ?></span>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <?php if ($i < $lastCertIdx): ?><div class="cert-divider"></div><?php endif; ?>
                <?php endforeach; ?>
                <div class="cert-divider"></div>
                <div class="show-all-certifications">
                    <a href="#" class="show-all-link">Show all <?= count($profile['certifications']) ?> licenses & certifications →</a>
                </div>
            </div>
            <?php endif; ?>
        </div>
        </div>

        <div class="right-sidebar-column">
        <aside class="right-sidebar">
            <h2 class="sidebar-title">More companies for you</h2>
            <div class="company-list">
                <div class="company-card">
                    <div class="company-avatar">
                        <div class="company-logo-placeholder">T</div>
                    </div>
                    <div class="company-info">
                        <h3 class="company-name">TechCorp Solutions</h3>
                        <p class="company-jobs">10+ Jobs Openings</p>
                        <button class="btn-apply"><span class="btn-apply-icon">→</span> Apply Now</button>
                    </div>
                </div>
                <div class="company-divider"></div>
                <div class="company-card">
                    <div class="company-avatar">
                        <div class="company-logo-placeholder">D</div>
                    </div>
                    <div class="company-info">
                        <h3 class="company-name">Digital Ventures</h3>
                        <p class="company-jobs">5+ Jobs Openings</p>
                        <button class="btn-apply"><span class="btn-apply-icon">→</span> Apply Now</button>
                    </div>
                </div>
                <div class="company-divider"></div>
                <div class="company-card">
                    <div class="company-avatar">
                        <div class="company-logo-placeholder">I</div>
                    </div>
                    <div class="company-info">
                        <h3 class="company-name">Innovate Labs</h3>
                        <p class="company-jobs">8+ Jobs Openings</p>
                        <button class="btn-apply"><span class="btn-apply-icon">→</span> Apply Now</button>
                    </div>
                </div>
            </div>
        </aside>

        <aside class="skills-sidebar-box">
            <h2 class="sidebar-title">Skills</h2>
            <div class="skill-test-list">
                <div class="skill-test-card">
                    <div class="skill-test-avatar skill-logo react-logo">
                        <svg viewBox="-11.5 -10.23174 23 20.46348"><circle r="2.05" fill="currentColor"/><g stroke="currentColor" stroke-width="1" fill="none"><ellipse rx="11" ry="4.2"/><ellipse rx="11" ry="4.2" transform="rotate(60)"/><ellipse rx="11" ry="4.2" transform="rotate(120)"/></g></svg>
                    </div>
                    <div class="skill-test-info">
                        <h3 class="skill-test-name">React</h3>
                        <button class="btn-attempt-test"><span class="btn-attempt-icon">→</span> Attempt test</button>
                    </div>
                </div>
                <div class="skill-test-divider"></div>
                <div class="skill-test-card">
                    <div class="skill-test-avatar skill-logo html-logo">
                        <svg viewBox="0 0 24 24" fill="currentColor"><path d="M1.5 0h21l-1.91 21.563L11.977 24l-8.565-2.438L1.5 0zm7.031 9.75-.232-2.718 10.059.003.23-2.622L5.412 4.41l.698 8.01h9.126l-.326 3.426-2.91.804-2.955-.81-.188-2.11H6.248l.33 4.171L12 19.351l5.379-1.443.744-8.157H8.531z"/></svg>
                    </div>
                    <div class="skill-test-info">
                        <h3 class="skill-test-name">HTML</h3>
                        <button class="btn-attempt-test"><span class="btn-attempt-icon">→</span> Attempt test</button>
                    </div>
                </div>
                <div class="skill-test-divider"></div>
                <div class="skill-test-card">
                    <div class="skill-test-avatar skill-logo dotnet-logo">
                        <svg viewBox="0 0 24 24" fill="currentColor"><path d="M3.972 2.08a.174.174 0 0 0-.152.087L.763 7.127a.174.174 0 0 0 .152.26h1.453a.174.174 0 0 0 .151-.088l.307-.528a.174.174 0 0 1 .152-.087h1.762a.174.174 0 0 1 .151.087l.306.528a.174.174 0 0 0 .152.088h1.453a.174.174 0 0 0 .152-.26L4.124 2.167a.174.174 0 0 0-.152-.087z"/></svg>
                    </div>
                    <div class="skill-test-info">
                        <h3 class="skill-test-name">.Net</h3>
                        <button class="btn-attempt-test"><span class="btn-attempt-icon">→</span> Attempt test</button>
                    </div>
                </div>
                <div class="skill-test-divider"></div>
                <div class="skill-test-card">
                    <div class="skill-test-avatar skill-logo js-logo">
                        <svg viewBox="0 0 24 24" fill="currentColor"><path d="M0 0h24v24H0V0z"/><path d="M22.034 18.276c-.175-1.095-.888-2.015-3.003-2.873.736-.345 1.554-.585 1.797-1.14.091-.33.105-.51.046-.705-.15-.646-.913-.84-1.515-.66-.39.12-1.652.42-2.86 1.376 0 0 .548.41.945.646-.225.473-.116.804.05 1.018.5.726 1.68.566 2.42.384-.485-.129-1.086-.465-1.603-.979-.265-.264-.455-.534-.665-.988"/></svg>
                    </div>
                    <div class="skill-test-info">
                        <h3 class="skill-test-name">JavaScript</h3>
                        <button class="btn-attempt-test"><span class="btn-attempt-icon">→</span> Attempt test</button>
                    </div>
                </div>
                <div class="skill-test-divider"></div>
                <div class="skill-test-card">
                    <div class="skill-test-avatar skill-logo aws-logo">
                        <svg viewBox="0 0 24 24" fill="currentColor"><path d="M6.763 10.036c0 .296.032.535.088.711.064.24.16.455.256.639"/></svg>
                    </div>
                    <div class="skill-test-info">
                        <h3 class="skill-test-name">AWS</h3>
                        <button class="btn-attempt-test"><span class="btn-attempt-icon">→</span> Attempt test</button>
                    </div>
                </div>
                <div class="skill-test-divider"></div>
                <div class="skill-test-card">
                    <div class="skill-test-avatar skill-logo devops-logo">
                        <svg viewBox="0 0 24 24" fill="currentColor"><path d="M19.14 12.94c.04-.31.06-.63.06-.94 0-.31-.02-.63-.06-.94l2.03-1.58c.18-.14.23-.41.12-.61l-1.92-3.32c-.12-.22-.37-.29-.59-.22l-2.39.96c-.5-.38-1.03-.7-1.62-.94l-.36-2.54c-.04-.24-.24-.41-.48-.41h-3.84c-.24 0-.43.17-.47.41l-.36 2.54c-.59.24-1.13.57-1.62.94l-2.39-.96c-.22-.08-.47 0-.59.22L2.74 8.87c-.12.21-.08.47.12.61l2.03 1.58c-.04.31-.06.63-.06.94s.02.63.06.94l-2.03 1.58c-.18.14-.23.41-.12.61l1.92 3.32c.12.22.37.29.59.22l2.39-.96c.5.38 1.03.7 1.62.94l.36 2.54c.05.24.24.41.48.41h3.84c.24 0 .44-.17.47-.41l.36-2.54c.59-.24 1.13-.56 1.62-.94l2.39.96c.22.08.47 0 .59-.22l1.92-3.32c.12-.22.07-.47-.12-.61l-2.01-1.58zM12 15.6c-1.98 0-3.6-1.62-3.6-3.6s1.62-3.6 3.6-3.6 3.6 1.62 3.6 3.6-1.62 3.6-3.6 3.6z"/></svg>
                    </div>
                    <div class="skill-test-info">
                        <h3 class="skill-test-name">DevOps</h3>
                        <button class="btn-attempt-test"><span class="btn-attempt-icon">→</span> Attempt test</button>
                    </div>
                </div>
            </div>
        </aside>
        </div>
    </div>
    </div>

    <footer class="site-footer">
        <div class="footer-container">
            <div class="footer-columns">
                <div class="footer-col">
                    <a href="#">About</a>
                    <a href="#">Professional Community Policies</a>
                    <a href="#">Privacy & Terms <span class="dropdown-icon">▾</span></a>
                    <a href="#">Sales Solutions</a>
                    <a href="#">Safety Center</a>
                </div>
                <div class="footer-col">
                    <a href="#">Accessibility</a>
                    <a href="#">Careers</a>
                    <a href="#">Ad Choices</a>
                    <a href="#">Mobile</a>
                </div>
                <div class="footer-col">
                    <a href="#">Talent Solutions</a>
                    <a href="#">Marketing Solutions</a>
                    <a href="#">Advertising</a>
                    <a href="#">Small Business</a>
                </div>
                <div class="footer-col footer-col-newsletter">
                    <h4 class="newsletter-title">Subscribe for newsletter</h4>
                    <p class="newsletter-subtext">Get updates on jobs and career tips.</p>
                    <form class="newsletter-form" onsubmit="return false;">
                        <input type="email" class="newsletter-input" placeholder="Enter your email" required>
                        <button type="submit" class="newsletter-btn">Subscribe</button>
                    </form>
                </div>
                <div class="footer-col footer-col-help">
                    <div class="footer-help-item">
                        <span class="footer-help-icon">
                            <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><circle cx="12" cy="12" r="10"/><path d="M9.09 9a3 3 0 0 1 5.83 1c0 2-3 3-3 3"/><line x1="12" y1="17" x2="12.01" y2="17"/></svg>
                        </span>
                        <div class="footer-help-content">
                            <span class="footer-help-title">Questions?</span>
                            <a href="#" class="footer-help-link">Visit our Help Center.</a>
                        </div>
                    </div>
                    <div class="footer-help-item">
                        <span class="footer-help-icon">
                            <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><circle cx="12" cy="12" r="3"/><path d="M19.4 15a1.65 1.65 0 0 0 .33 1.82l.06.06a2 2 0 0 1 0 2.83 2 2 0 0 1-2.83 0l-.06-.06a1.65 1.65 0 0 0-1.82-.33 1.65 1.65 0 0 0-1 1.51V21a2 2 0 0 1-2 2 2 2 0 0 1-2-2v-.09A1.65 1.65 0 0 0 9 19.4a1.65 1.65 0 0 0-1.82.33l-.06.06a2 2 0 0 1-2.83 0 2 2 0 0 1 0-2.83l.06-.06a1.65 1.65 0 0 0 .33-1.82 1.65 1.65 0 0 0-1.51-1H3a2 2 0 0 1-2-2 2 2 0 0 1 2-2h.09A1.65 1.65 0 0 0 4.6 9a1.65 1.65 0 0 0-.33-1.82l-.06-.06a2 2 0 0 1 0-2.83 2 2 0 0 1 2.83 0l.06.06a1.65 1.65 0 0 0 1.82.33H9a1.65 1.65 0 0 0 1-1.51V3a2 2 0 0 1 2-2 2 2 0 0 1 2 2v.09a1.65 1.65 0 0 0 1 1.51 1.65 1.65 0 0 0 1.82-.33l.06-.06a2 2 0 0 1 2.83 0 2 2 0 0 1 0 2.83l-.06.06a1.65 1.65 0 0 0-.33 1.82V9a1.65 1.65 0 0 0 1.51 1H21a2 2 0 0 1 2 2 2 2 0 0 1-2 2h-.09a1.65 1.65 0 0 0-1.51 1z"/></svg>
                        </span>
                        <div class="footer-help-content">
                            <span class="footer-help-title">Manage your account and privacy</span>
                            <a href="#" class="footer-help-link">Go to your Settings.</a>
                        </div>
                    </div>
                    <div class="footer-help-item">
                        <span class="footer-help-icon">
                            <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"/></svg>
                        </span>
                        <div class="footer-help-content">
                            <span class="footer-help-title">Recommendation transparency</span>
                            <a href="#" class="footer-help-link">Learn more about Recommended Content.</a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="footer-bottom">
                <span class="footer-copyright">MFStrive © 2026</span>
            </div>
        </div>
    </footer>

    <script src="script.js"></script>
</body>
</html>
