// Me dropdown toggle
document.addEventListener('DOMContentLoaded', function() {
    const navMe = document.getElementById('navMe');
    const meDropdown = document.getElementById('meDropdown');

    if (navMe && meDropdown) {
        navMe.addEventListener('click', function(e) {
            const link = e.target.closest('a[href]');
            if (link && link.getAttribute('href') !== '#' && link.getAttribute('href') !== '') {
                return; // Allow navigation (e.g. Sign Out)
            }
            e.preventDefault();
            meDropdown.classList.toggle('open');
        });

        // Close dropdown when clicking outside
        document.addEventListener('click', function(e) {
            if (!navMe.contains(e.target) && !meDropdown.contains(e.target)) {
                meDropdown.classList.remove('open');
            }
        });
    }
});

// Toggle About section expand/collapse
function toggleAbout() {
    const aboutContent = document.querySelector('.about-content');
    aboutContent.classList.toggle('about-text-expanded');
    
    const seeMoreBtn = document.querySelector('.see-more-btn');
    if (aboutContent.classList.contains('about-text-expanded')) {
        seeMoreBtn.textContent = '...see less';
    } else {
        seeMoreBtn.textContent = '...see more';
    }
}

// Add smooth scrolling for anchor links
document.querySelectorAll('a[href^="#"]').forEach(anchor => {
    anchor.addEventListener('click', function (e) {
        e.preventDefault();
        const target = document.querySelector(this.getAttribute('href'));
        if (target) {
            target.scrollIntoView({
                behavior: 'smooth',
                block: 'start'
            });
        }
    });
});

// Add hover effects to interactive elements
document.addEventListener('DOMContentLoaded', function() {
    // Add hover effect to skill items
    const skillItems = document.querySelectorAll('.skill-item');
    skillItems.forEach(item => {
        item.addEventListener('mouseenter', function() {
            this.style.backgroundColor = 'transparent';
        });
        item.addEventListener('mouseleave', function() {
            this.style.backgroundColor = 'transparent';
        });
    });

    // Add hover effect to certification items
    const certItems = document.querySelectorAll('.certification-item');
    certItems.forEach(item => {
        item.addEventListener('mouseenter', function() {
            this.style.backgroundColor = 'transparent';
        });
        item.addEventListener('mouseleave', function() {
            this.style.backgroundColor = 'transparent';
        });
    });

    // Add click handlers for "Show all" links
    const showAllLinks = document.querySelectorAll('.show-all-link');
    showAllLinks.forEach(link => {
        link.addEventListener('click', function(e) {
            e.preventDefault();
            // In a real application, this would load more items
            alert('This would show all items. In a real application, this would load more data.');
        });
    });

    // Add click handler for "Show credential" button
    const showCredentialBtns = document.querySelectorAll('.show-credential-btn');
    showCredentialBtns.forEach(btn => {
        btn.addEventListener('click', function(e) {
            e.preventDefault();
            // In a real application, this would open a modal or redirect to credential page
            alert('This would show the credential. In a real application, this would open a modal or redirect to the credential page.');
        });
    });
});
