<?php
/**
 * Run this script once to create the database tables.
 * Access via: http://localhost/mfstrive/careers-profile/setup_database.php
 * Delete this file after successful setup for security.
 */

$host = 'localhost';
$username = 'root';
$password = '';
$database = 'mfstrive';

$conn = new mysqli($host, $username, $password);

if ($conn->connect_error) {
    die('Database connection failed: ' . $conn->connect_error);
}

$conn->query("CREATE DATABASE IF NOT EXISTS $database");
$conn->select_db($database);

$sql = "
CREATE TABLE IF NOT EXISTS users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(100) NOT NULL UNIQUE,
    password VARCHAR(255) NOT NULL,
    first_name VARCHAR(100) NOT NULL,
    last_name VARCHAR(100) NOT NULL,
    email VARCHAR(255) NOT NULL UNIQUE,
    phone VARCHAR(50) NOT NULL,
    signature_path VARCHAR(500) DEFAULT NULL,
    resume_path VARCHAR(500) DEFAULT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX idx_username (username),
    INDEX idx_email (email)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
";

if ($conn->query($sql)) {
    echo '<h2>Database setup complete!</h2>';
    echo '<p>Tables created successfully in database: ' . htmlspecialchars($database) . '</p>';
    echo '<p><a href="auth.html">Go to Login / Sign Up</a></p>';
} else {
    echo 'Error: ' . $conn->error;
}
$conn->close();
