<?php
/**
 * Run this script once to add profile tables and columns.
 * Access via: http://localhost/mfstrive/careers-profile/setup_profile_tables.php
 * Safe to run multiple times - checks before adding columns.
 */

require_once __DIR__ . '/config/database.php';

$columns_to_add = [
    'headline' => "VARCHAR(500) DEFAULT NULL",
    'location' => "VARCHAR(255) DEFAULT NULL",
    'about' => "TEXT DEFAULT NULL",
    'about_extended' => "TEXT DEFAULT NULL",
    'open_to_work_roles' => "VARCHAR(500) DEFAULT NULL",
    'score_rating' => "VARCHAR(20) DEFAULT '8/10'",
    'score_points' => "VARCHAR(50) DEFAULT '10245 points'",
    'connection_degree' => "VARCHAR(20) DEFAULT '2nd'"
];

$added = [];
$skipped = [];
$result = $conn->query("DESCRIBE users");
$existing_columns = [];
while ($row = $result->fetch_assoc()) {
    $existing_columns[] = $row['Field'];
}

foreach ($columns_to_add as $col => $def) {
    if (!in_array($col, $existing_columns)) {
        $sql = "ALTER TABLE users ADD COLUMN `$col` $def";
        if ($conn->query($sql)) {
            $added[] = $col;
        }
    } else {
        $skipped[] = $col;
    }
}

// Create profile tables
$tables_sql = [
    "CREATE TABLE IF NOT EXISTS user_experiences (
        id INT AUTO_INCREMENT PRIMARY KEY,
        user_id INT NOT NULL,
        company_name VARCHAR(255) NOT NULL,
        job_title VARCHAR(255) NOT NULL,
        employment_type VARCHAR(100) DEFAULT 'Full-time',
        start_date VARCHAR(100) DEFAULT NULL,
        end_date VARCHAR(100) DEFAULT NULL,
        duration VARCHAR(100) DEFAULT NULL,
        location VARCHAR(255) DEFAULT NULL,
        skills TEXT DEFAULT NULL,
        description TEXT DEFAULT NULL,
        display_order INT DEFAULT 0,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
        INDEX idx_user_id (user_id)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci",
    "CREATE TABLE IF NOT EXISTS user_education (
        id INT AUTO_INCREMENT PRIMARY KEY,
        user_id INT NOT NULL,
        institution_name VARCHAR(255) NOT NULL,
        degree VARCHAR(255) NOT NULL,
        start_date VARCHAR(100) DEFAULT NULL,
        end_date VARCHAR(255) DEFAULT NULL,
        grade VARCHAR(100) DEFAULT NULL,
        location VARCHAR(255) DEFAULT NULL,
        skills TEXT DEFAULT NULL,
        display_order INT DEFAULT 0,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
        INDEX idx_user_id (user_id)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci",
    "CREATE TABLE IF NOT EXISTS user_skills (
        id INT AUTO_INCREMENT PRIMARY KEY,
        user_id INT NOT NULL,
        skill_name VARCHAR(255) NOT NULL,
        institution VARCHAR(255) DEFAULT NULL,
        is_top_skill TINYINT(1) DEFAULT 0,
        display_order INT DEFAULT 0,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
        INDEX idx_user_id (user_id)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci",
    "CREATE TABLE IF NOT EXISTS user_certifications (
        id INT AUTO_INCREMENT PRIMARY KEY,
        user_id INT NOT NULL,
        title VARCHAR(500) NOT NULL,
        issuer VARCHAR(255) DEFAULT NULL,
        issued_date VARCHAR(100) DEFAULT NULL,
        credential_id VARCHAR(255) DEFAULT NULL,
        skills TEXT DEFAULT NULL,
        display_order INT DEFAULT 0,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
        INDEX idx_user_id (user_id)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci"
];

foreach ($tables_sql as $sql) {
    $conn->query($sql);
}

echo '<h2>Profile tables setup complete!</h2>';
echo '<p>Columns added: ' . (count($added) ? implode(', ', $added) : 'none (already exist)') . '</p>';
echo '<p>Tables: user_experiences, user_education, user_skills, user_certifications</p>';
echo '<p><a href="index.php">Go to Login</a> | <a href="profile.php">View Profile</a></p>';
$conn->close();
