<?php
/**
 * Premium Landing Page
 * 
 * To run locally:
 * php -S localhost:8000
 * Then visit http://localhost:8000
 */
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>MF STRIVE - The End of the Resume Guessing Game</title>
    <meta name="description" content="UK-engineered AI that deconstructs every candidate's DNA—from technical mastery to leadership intuition.">
    
    <!-- Favicon -->
    <link rel="icon" type="image/svg+xml" href="assets/img/favicon.svg">
    <link rel="icon" type="image/png" href="data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 100 100'%3E%3Cdefs%3E%3ClinearGradient id='g' x1='0%25' y1='0%25' x2='100%25' y2='100%25'%3E%3Cstop offset='0%25' style='stop-color:%2300caff'/%3E%3Cstop offset='100%25' style='stop-color:%2300a5cc'/%3E%3C/linearGradient%3E%3C/defs%3E%3Crect width='100' height='100' fill='%231a1a1d'/%3E%3Cpath d='M20 30 L20 70 L30 70 L30 50 L40 70 L50 70 L40 50 L40 30 Z' fill='url(%23g)'/%3E%3Cpath d='M50 30 L50 70 L60 70 L60 50 L70 50 L70 40 L60 40 L60 30 Z' fill='%23fff'/%3E%3Cpath d='M15 75 L35 55 L45 65 L75 35 L85 45 L45 85 Z' fill='%23fff' opacity='0.85'/%3E%3C/svg%3E">
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&family=Space+Grotesk:wght@400;500;600;700&family=Poppins:wght@400;500;600;700;800&family=Montserrat:wght@600;700;800;900&display=swap" rel="stylesheet">
    
    <!-- Custom CSS -->
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <!-- Animated Background -->
    <div class="animated-bg">
        <div class="blob blob-1"></div>
        <div class="blob blob-2"></div>
        <div class="blob blob-3"></div>
        <div class="noise-overlay"></div>
    </div>

    <!-- Sticky Navbar -->
    <nav class="navbar navbar-expand-lg navbar-dark fixed-top" id="mainNav">
        <div class="container">
            <a class="navbar-brand" href="#hero">
                <img src="assets/img/logo-h.png" alt="MF STRIVE" class="logo-img">
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto align-items-center">
                    <li class="nav-item">
                        <a class="nav-link active" href="#hero">Home</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#curiosity">Services</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#demo">Careers</a>
                    </li>
                </ul>
                <a href="#demo" class="btn btn-nav-cta ms-3" aria-label="Get started">Get Started</a>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section id="hero" class="hero-section section-dark">
        <!-- Video Background -->
        <video class="hero-video-bg" autoplay muted loop playsinline>
            <source src="assets/video/banner-bg.mp4" type="video/mp4">
            Your browser does not support the video tag.
        </video>
        <div class="hero-overlay"></div>
        <div class="container hero-content">
            <div class="row justify-content-center text-center min-vh-100 align-items-center">
                <div class="col-lg-10 col-xl-8">
                    <h1 class="hero-headline" data-animate="hero">
                        <span class="gradient-text">The End</span> of the <span class="gradient-text">Resume Guessing Game</span>.
                    </h1>
                    <p class="hero-subheadline" data-animate="hero">Stop losing hours to "keyword-stuffed" CVs. Our UK-engineered AI deconstructs every candidate's DNA—from technical mastery to leadership intuition—giving you the truth in seconds.</p>
                    <div class="hero-cta-buttons" data-animate="hero">
                        <a href="#demo" class="btn btn-primary-cta btn-lg hero-cta" aria-label="Request exclusive demo">Request My Exclusive Demo →</a>
                        <a href="#curiosity" class="btn btn-secondary-cta btn-lg hero-cta" aria-label="View features">View Features</a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Cards Slider Section -->
    <section id="cards-slider" class="section-padding section-light">
        <div class="container">
            <div class="cards-slider-wrapper">
                <div class="slider-container">
                    <div class="slider-track">
                        <div class="slider-card-wrapper">
                            <div class="glass-card slider-card">
                                <h2 class="section-heading" data-animate="fade-up">You aren't hiring talent; you're hiring professional resume writers.</h2>
                                <p class="section-body" data-animate="fade-up">In a world of AI-generated CVs, everyone looks perfect on paper. The result? Your team wastes 70% of their week interviewing candidates who lack the actual depth required for the role. You don't need more applicants. You need more clarity.</p>
                            </div>
                        </div>
                        <div class="slider-card-wrapper">
                            <div class="glass-card slider-card">
                                <h2 class="section-heading" data-animate="fade-up">From London to Lahore: Global Intelligence, Local Expertise.</h2>
                                <p class="section-body" data-animate="fade-up">Founded in the United Kingdom and built on rigorous corporate standards, MF STRIVE is now expanding into Pakistan and the Middle East. We bridge the gap between global hiring standards and regional talent nuances. Whether you are a London tech firm or a Dubai conglomerate, we provide the same gold standard of verification.</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="slider-navigation">
                    <button class="slider-nav-btn slider-nav-prev" aria-label="Previous card">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M15 18l-6-6 6-6"/>
                        </svg>
                    </button>
                    <button class="slider-nav-btn slider-nav-next" aria-label="Next card">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M9 18l6-6-6-6"/>
                        </svg>
                    </button>
                </div>
                <div class="slider-indicators">
                    <button class="slider-indicator active" data-slide="0" aria-label="Go to slide 1"></button>
                    <button class="slider-indicator" data-slide="1" aria-label="Go to slide 2"></button>
                </div>
                <div class="slider-progress">
                    <div class="slider-progress-bar"></div>
                </div>
            </div>
        </div>
    </section>

    <!-- Services Section -->
    <section id="curiosity" class="section-padding section-light">
        <div class="container">
            <div class="row justify-content-center mb-5">
                <div class="col-lg-8 text-center">
                    <h2 class="section-heading" data-animate="fade-up">Our Services</h2>
                    <p class="section-subtitle" data-animate="fade-up">Comprehensive solutions for modern talent acquisition</p>
                </div>
            </div>
            <div class="services-grid">
                <div class="service-card-modern" data-animate="stagger" data-service="1">
                    <div class="service-card-bg"></div>
                    <div class="service-content">
                        <div class="service-icon-wrapper">
                            <div class="service-icon">🧠</div>
                            <div class="service-icon-glow"></div>
                        </div>
                        <div class="service-number">01</div>
                        <h3 class="service-title">Talent Intelligence Platform</h3>
                        <p class="service-tagline">Hiring should not feel like guesswork.</p>
                        <p class="service-description">Our software helps HR teams identify the right talent faster. Smart insights replace endless resume hunting.</p>
                        <div class="service-arrow">→</div>
                    </div>
                </div>
                <div class="service-card-modern" data-animate="stagger" data-service="2">
                    <div class="service-card-bg"></div>
                    <div class="service-content">
                        <div class="service-icon-wrapper">
                            <div class="service-icon">👥</div>
                            <div class="service-icon-glow"></div>
                        </div>
                        <div class="service-number">02</div>
                        <h3 class="service-title">Resource Augmentation Services</h3>
                        <p class="service-tagline">Need skilled professionals without long-term commitments?</p>
                        <p class="service-description">We place qualified resources through our operational setup. You scale teams without scaling chaos.</p>
                        <div class="service-arrow">→</div>
                    </div>
                </div>
                <div class="service-card-modern" data-animate="stagger" data-service="3">
                    <div class="service-card-bg"></div>
                    <div class="service-content">
                        <div class="service-icon-wrapper">
                            <div class="service-icon">📋</div>
                            <div class="service-icon-glow"></div>
                        </div>
                        <div class="service-number">03</div>
                        <h3 class="service-title">Career Profile Hub</h3>
                        <p class="service-tagline">One profile. One resume. Real visibility.</p>
                        <p class="service-description">Candidates showcase skills, experience, and career growth. Recruiters find talent without chasing it.</p>
                        <div class="service-arrow">→</div>
                    </div>
                </div>
                <div class="service-card-modern" data-animate="stagger" data-service="4">
                    <div class="service-card-bg"></div>
                    <div class="service-content">
                        <div class="service-icon-wrapper">
                            <div class="service-icon">🎓</div>
                            <div class="service-icon-glow"></div>
                        </div>
                        <div class="service-number">04</div>
                        <h3 class="service-title">Professional Training Programs</h3>
                        <p class="service-tagline">We train people for real work, not just certificates.</p>
                        <p class="service-description">Technical, non-technical, and application-based learning included. Skills improve. Performance follows.</p>
                        <div class="service-arrow">→</div>
                    </div>
                </div>
                <div class="service-card-modern" data-animate="stagger" data-service="5">
                    <div class="service-card-bg"></div>
                    <div class="service-content">
                        <div class="service-icon-wrapper">
                            <div class="service-icon">📊</div>
                            <div class="service-icon-glow"></div>
                        </div>
                        <div class="service-number">05</div>
                        <h3 class="service-title">Skill Assessment & Scoring</h3>
                        <p class="service-tagline">Every candidate gets measured, not guessed.</p>
                        <p class="service-description">Scores are based on skills, experience, and relevance. Hiring decisions finally make sense.</p>
                        <div class="service-arrow">→</div>
                    </div>
                </div>
                <div class="service-card-modern" data-animate="stagger" data-service="6">
                    <div class="service-card-bg"></div>
                    <div class="service-content">
                        <div class="service-icon-wrapper">
                            <div class="service-icon">🌍</div>
                            <div class="service-icon-glow"></div>
                        </div>
                        <div class="service-number">06</div>
                        <h3 class="service-title">Global Recruitment Solutions</h3>
                        <p class="service-tagline">Talent does not stop at borders.</p>
                        <p class="service-description">We connect candidates with international and remote opportunities. Global hiring, simplified.</p>
                        <div class="service-arrow">→</div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- The Closing Section -->
    <section id="demo" class="section-padding closing-section section-dark">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8 text-center">
                    <div class="glass-card closing-card">
                        <h2 class="section-heading" data-animate="fade-up">Ready to see the future of your talent pipeline?</h2>
                        <p class="section-body" data-animate="fade-up">We are currently onboarding a select group of partners for our Pakistan and Middle East expansion. Secure your spot to see how the world's most efficient teams are hiring in 2026.</p>
                        <a href="#demo" class="btn btn-primary-cta btn-lg closing-cta" data-animate="pulse" aria-label="Request demo now">Request My Demo Now</a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <div class="row">
                <div class="col-12 text-center">
                    <p class="footer-text">&copy; <?php echo date('Y'); ?> MF STRIVE. All rights reserved.</p>
                </div>
            </div>
        </div>
    </footer>

    <!-- Bootstrap 5 JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- GSAP -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/gsap.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/ScrollTrigger.min.js"></script>
    
    <!-- Custom JS -->
    <script src="assets/js/main.js"></script>
</body>
</html>
