<?php
// Simple autoloader for PDF Parser
spl_autoload_register(function ($class) {
    $prefix = "Smalot\\PdfParser\\";
    $base_dir = __DIR__ . "/smalot/pdfparser/src/Smalot/PdfParser/";
    
    $len = strlen($prefix);
    if (strncmp($prefix, $class, $len) !== 0) {
        return;
    }
    
    $relative_class = substr($class, $len);
    $file = $base_dir . str_replace("\\", "/", $relative_class) . ".php";
    
    if (file_exists($file)) {
        require $file;
    }
});
