# Installing PDF Parser for Skills Extraction

This guide will help you set up the PDF parsing functionality for the Skills Extractor feature.

## Prerequisites

- PHP 7.4 or higher
- Composer (PHP dependency manager)

## Step 1: Install Composer (if not already installed)

### Windows (WAMP)

1. Download Composer from: https://getcomposer.org/download/
2. Run the installer: `Composer-Setup.exe`
3. Follow the installation wizard
4. Restart your terminal/command prompt after installation

### Verify Installation

Open a command prompt and run:
```bash
composer --version
```

You should see something like: `Composer version 2.x.x`

## Step 2: Install PDF Parser Library

Navigate to your project directory and run:

```bash
cd C:\wamp64\www\AnaForm
composer install
```

Or install the package directly:

```bash
composer require smalot/pdfparser
```

This will create a `vendor` folder with all required dependencies.

## Step 3: Verify Installation

After installation, check that the `vendor` folder exists:

```
C:\wamp64\www\AnaForm\vendor\
```

## Step 4: Test the Feature

1. Place some PDF resume files in the `pdfs/` folder
2. Open your browser and navigate to:
   ```
   http://localhost/AnaForm/view_skills.php
   ```
3. You should see the PDF Skills Extractor page with extracted skills

## Troubleshooting

### Error: "composer: command not found"

- Make sure Composer is installed
- Restart your terminal/command prompt
- Add Composer to your system PATH

### Error: "PHP version not supported"

- Update PHP to version 7.4 or higher
- In WAMP, you can change PHP version from the WAMP menu

### Error: "Cannot parse PDF"

- Make sure the PDF is not password-protected
- Ensure the PDF contains readable text (not just images)
- Some scanned PDFs may not work without OCR

### Error: "vendor/autoload.php not found"

- Run `composer install` in the project directory
- Make sure the vendor folder exists

## Alternative: Manual Installation

If you can't use Composer, you can download the PDF Parser library manually:

1. Download from: https://github.com/smalot/pdfparser/releases
2. Extract to `vendor/smalot/pdfparser/`
3. Create an autoloader or manually require the necessary files

However, using Composer is strongly recommended.

## Support

For more help, see:
- Composer documentation: https://getcomposer.org/doc/
- PDF Parser documentation: https://github.com/smalot/pdfparser


