# AnaForm - PHP Registration Form with Signature

A complete PHP form application with signature drawing capability using HTML5 Canvas.

## Features

- ✅ User registration form with validation
- ✅ Signature drawing with mouse/touch support
- ✅ Data storage (JSON file or MySQL database)
- ✅ Responsive design
- ✅ Modern UI with gradient styling
- ✅ Success page with submitted data preview
- ✅ PDF Skills Extractor - Automatically extract skills from resume PDFs

## Form Fields

1. **Username** - Unique identifier
2. **First Name** - User's first name
3. **Last Name** - User's last name
4. **Email** - Valid email address
5. **Phone Number** - Contact number
6. **Signature** - Hand-drawn signature using canvas

## Installation

### Requirements
- PHP 7.4 or higher
- Web server (Apache/Nginx)
- Write permissions for signatures folder
- Composer (for PDF parsing feature)

### Setup

1. **Copy files to your web directory**
   ```
   Copy all files to: C:\wamp64\www\AnaForm\
   ```

2. **Create signatures directory**
   ```
   The application will automatically create the 'signatures' folder, 
   but you can manually create it and set permissions to 755
   ```

3. **Install dependencies (for PDF Skills Extractor)**
   ```bash
   composer install
   ```
   Or manually:
   ```bash
   composer require smalot/pdfparser
   ```

4. **Access the form**
   ```
   http://localhost/AnaForm/
   ```

## Storage

The form uses **JSON file storage** for simplicity and portability:
- All form submissions are saved to `users_data.json`
- Signatures are saved as PNG images in the `signatures/` folder
- No database setup required
- Easy to backup and transfer

## File Structure

```
AnaForm/
├── index.php              # Main form page
├── process.php            # Form processing script
├── success.php            # Success confirmation page
├── view_records.php       # View all submitted records
├── view_skills.php        # PDF skills extraction page
├── config.php             # Configuration settings
├── style.css              # Stylesheet
├── signature.js           # Signature canvas functionality
├── composer.json          # Composer dependencies
├── .htaccess              # Security settings
├── README.md              # This file
├── pdfs/                  # PDF files for skills extraction
├── signatures/            # Signature images (auto-created)
├── vendor/                # Composer dependencies (auto-created)
└── users_data.json        # User data storage (auto-created)
```

## How to Use

1. **Open the form** in your browser
2. **Fill in all required fields**
3. **Draw your signature** in the signature box
   - Use mouse to draw on desktop
   - Use finger/stylus on touch devices
   - Click "Clear Signature" to redraw
4. **Submit the form**
5. **View confirmation page** with submitted data

## Signature Feature

- **Drawing**: Click and drag to draw on the canvas
- **Touch Support**: Works on mobile devices and tablets
- **Clear**: Remove signature and start over
- **Validation**: Form won't submit without a signature
- **Storage**: Signature saved as PNG image

## Security Features

- Input sanitization and validation
- XSS protection with htmlspecialchars
- Email validation
- Session-based success page access
- Base64 image encoding validation

## Customization

### Change Colors
Edit `style.css` to modify the gradient and colors:
```css
background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
```

### Add More Fields
1. Add input field in `index.php`
2. Update validation in `process.php`
3. Update database schema if using MySQL

### Modify Signature Canvas Size
Edit in `signature.js`:
```javascript
canvas.height = 200; // Change height here
```

### View All Records
Access `view_records.php` to see all submitted forms with searchable table and signature previews.

## PDF Skills Extractor

The PDF Skills Extractor automatically reads resume PDFs and extracts technical and soft skills.

### How to Use

1. **Install Dependencies**
   ```bash
   composer install
   ```

2. **Add PDF Files**
   - Place resume PDF files in the `pdfs/` folder

3. **Access the Skills Extractor**
   ```
   http://localhost/AnaForm/view_skills.php
   ```

### Features

- 📄 **Automatic PDF Parsing** - Reads all PDFs in the pdfs folder
- 🎯 **Skill Extraction** - Identifies 100+ technical and soft skills
- 📊 **Statistics Dashboard** - Shows total PDFs, unique skills, and total skills found
- 🔍 **Individual Results** - View skills found in each PDF separately
- 💼 **Skills Cloud** - See all unique skills across all PDFs
- 📱 **Responsive Design** - Works on all devices

### Supported Skills Categories

- **Programming Languages**: PHP, JavaScript, Python, Java, C++, etc.
- **Web Technologies**: HTML, CSS, React, Angular, Vue.js, Node.js, etc.
- **Databases**: MySQL, PostgreSQL, MongoDB, Redis, etc.
- **DevOps & Tools**: Git, Docker, Kubernetes, AWS, Azure, etc.
- **Mobile Development**: Android, iOS, React Native, Flutter, etc.
- **Testing**: Jest, Selenium, PHPUnit, etc.
- **Design**: Photoshop, Figma, UI/UX, etc.
- **Soft Skills**: Leadership, Communication, Problem Solving, etc.

## Browser Support

- ✅ Chrome/Edge (recommended)
- ✅ Firefox
- ✅ Safari
- ✅ Mobile browsers (iOS/Android)

## Troubleshooting

### Signatures not saving
- Check folder permissions on `signatures/` directory
- Ensure PHP has write permissions

### Form not submitting
- Check browser console for JavaScript errors
- Verify all fields are filled
- Ensure signature is drawn

### Data not saving
- Check write permissions on root folder
- Verify `users_data.json` can be created/modified

## License

Free to use and modify for personal and commercial projects.

## Support

For issues or questions, please check:
- PHP error logs
- Browser console
- File permissions

