<?php
// Simple page to view all submitted records
$dataFile = 'users_data.json';
$users = [];

if (file_exists($dataFile)) {
    $jsonContent = file_get_contents($dataFile);
    $users = json_decode($jsonContent, true) ?? [];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>View Records - AnaForm</title>
    <link rel="stylesheet" href="style.css">
    <style>
        .records-container {
            background: white;
            border-radius: 15px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            padding: 40px;
            max-width: 1200px;
            margin: 0 auto;
        }
        
        .records-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
        }
        
        .records-header h1 {
            margin: 0;
        }
        
        .btn-add {
            padding: 10px 20px;
            background: #4CAF50;
            color: white;
            text-decoration: none;
            border-radius: 6px;
            font-weight: 600;
        }
        
        .btn-add:hover {
            background: #45a049;
        }
        
        .records-count {
            color: #666;
            margin-bottom: 20px;
            font-size: 14px;
        }
        
        .records-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        
        .records-table th {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 15px;
            text-align: left;
            font-weight: 600;
        }
        
        .records-table td {
            padding: 15px;
            border-bottom: 1px solid #e0e0e0;
        }
        
        .records-table tr:hover {
            background: #f5f5f5;
        }
        
        .signature-thumb {
            max-width: 100px;
            max-height: 50px;
            border: 1px solid #ddd;
            border-radius: 4px;
            cursor: pointer;
        }
        
        .no-records {
            text-align: center;
            padding: 40px;
            color: #999;
        }
        
        .modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.8);
            align-items: center;
            justify-content: center;
        }
        
        .modal.active {
            display: flex;
        }
        
        .modal-content {
            max-width: 90%;
            max-height: 90%;
        }
        
        .modal-close {
            position: absolute;
            top: 20px;
            right: 40px;
            color: white;
            font-size: 40px;
            font-weight: bold;
            cursor: pointer;
        }
        
        @media (max-width: 768px) {
            .records-table {
                font-size: 12px;
            }
            
            .records-table th,
            .records-table td {
                padding: 8px;
            }
        }
    </style>
</head>
<body>
    <div class="container" style="max-width: 1200px; margin: 20px auto;">
        <div class="records-container">
            <div class="records-header">
                <h1>All Registered Users</h1>
                <div>
                    <a href="view_skills.php" style="padding: 10px 20px; background: #667eea; color: white; text-decoration: none; border-radius: 6px; font-weight: 600; margin-right: 10px;">📄 PDF Skills</a>
                    <a href="search_skills.php" style="padding: 10px 20px; background: #28a745; color: white; text-decoration: none; border-radius: 6px; font-weight: 600; margin-right: 10px;">🔍 Search Skills</a>
                    <a href="index.php" class="btn-add">+ Add New User</a>
                </div>
            </div>
            
            <div class="records-count">
                Total Records: <strong><?php echo count($users); ?></strong>
            </div>
            
            <?php if (empty($users)): ?>
                <div class="no-records">
                    <h3>No records found</h3>
                    <p>Click "Add New User" to submit your first form.</p>
                </div>
            <?php else: ?>
                <div style="overflow-x: auto;">
                    <table class="records-table">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Username</th>
                                <th>Full Name</th>
                                <th>Email</th>
                                <th>Phone</th>
                                <th>Signature</th>
                                <th>Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach (array_reverse($users) as $index => $user): ?>
                                <tr>
                                    <td><?php echo $index + 1; ?></td>
                                    <td><?php echo htmlspecialchars($user['username']); ?></td>
                                    <td><?php echo htmlspecialchars($user['firstname'] . ' ' . $user['lastname']); ?></td>
                                    <td><?php echo htmlspecialchars($user['email']); ?></td>
                                    <td><?php echo htmlspecialchars($user['phone']); ?></td>
                                    <td>
                                        <?php if (!empty($user['signature_file']) && file_exists('signatures/' . $user['signature_file'])): ?>
                                            <img src="signatures/<?php echo htmlspecialchars($user['signature_file']); ?>" 
                                                 alt="Signature" 
                                                 class="signature-thumb"
                                                 onclick="showSignature('signatures/<?php echo htmlspecialchars($user['signature_file']); ?>')">
                                        <?php else: ?>
                                            <span style="color: #999;">N/A</span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo date('M d, Y H:i', strtotime($user['created_at'])); ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
        </div>
    </div>
    
    <!-- Modal for viewing signature -->
    <div id="signatureModal" class="modal" onclick="closeModal()">
        <span class="modal-close">&times;</span>
        <img id="modalImage" class="modal-content" src="" alt="Signature">
    </div>
    
    <!-- Loader Overlay -->
    <div class="loader-overlay" id="loaderOverlay">
        <div class="loader-container">
            <div class="loader-spinner"></div>
            <div class="loader-text" id="loaderText">Loading...</div>
            <div class="progress-bar-container">
                <div class="progress-bar"></div>
            </div>
            <div class="progress-text">Please wait...</div>
        </div>
    </div>
    
    <script>
        function showSignature(src) {
            document.getElementById('modalImage').src = src;
            document.getElementById('signatureModal').classList.add('active');
        }
        
        function closeModal() {
            document.getElementById('signatureModal').classList.remove('active');
        }
        
        // Show loader on navigation links
        document.addEventListener('DOMContentLoaded', function() {
            const links = document.querySelectorAll('a[href$=".php"]');
            links.forEach(link => {
                link.addEventListener('click', function(e) {
                    const loader = document.getElementById('loaderOverlay');
                    const loaderText = document.getElementById('loaderText');
                    loaderText.textContent = 'Loading page...';
                    loader.classList.add('active');
                });
            });
        });
    </script>
</body>
</html>

